/* -------- 
 * s-box.js version 1.01
 * Copyright (c) 2009 Hiroya Fujii
 * http://1-pixel.com/s-box.html
 * Dual licensed under the MIT and GPL licenses
 * This script uses jQuery and SimpleModal plugin.
 -------- */

var sbox = {};

sbox.conf = {

// Path to the directory which contains related graphics (arrow.gif, logo.png, etcs).
	graphicsDir: './s-box-graphics',

// It's logo's postion. In default, bottom and right attrubutes are set.
// 'top' and 'left' attributes also works of course.
	logoPosition: {
		bottom: '100px',
		right: '-60px'
	},

/* -------- PLEASE READ -----------

To let your logo shows up in modal, you need to do following:

	1. Prepare your own png image for the logo.
	2. Name it as 'logo.png'.
	3. Upload 'logo.png' to the directory which you set as 'graphicsDir' directory.
	4. Set the logoPosition parameter as you like.

 The script searches 'logo.png' inside the directory which you set as 'graphicsDir' at first loading.
 If found, the script try to grab logo's size and logoPosion paramter, then it shows up.
 Therefore, if you want to disable logo function, just simply detele 'logo.png'.

-------- */

// Css style for hover action.
// This style will be applied to img element wrapped by a element which has 'rel=lightbox' attribute.
	hoverIn: { opacity: 0.8, border: 'solid 1px red', margin: '2px' },
	hoverOut: { opacity: 1.0, border: 'solid 1px #535353', margin: '2px' },

// If true, rounded corner background image is used. If false, css-generated background is applied.
	bgImg: true,

// Background color. This option works only in case you set 'bgImg' as false.
	bgColor: '#ffffff',

// Background's padding. Set 0 (zero) if you want don't like padding.
	padding: 25,

// If true, arrow gif shows up. If false, never does.
	navArrow: true,

// Maximum size of prev and next thumbnail images.
	thumbMaxW: 200,
	thumbMaxH: 200

};

// Config part ends.

$(function(){
	sbox.func.setParam();
	sbox.func.reload();
	sbox.func.setImgs();
});

sbox.func = {

	setParam: function(){
		var _dir = sbox.conf.graphicsDir.replace(/\/$/, '') + '/';
		sbox.conf.navMargin = 10;
		sbox.conf.navH = 40;
		sbox.reload = [
			_dir + 'arrow.gif',
			_dir + 'ajax-loader-start.gif',
			_dir + 'ajax-loader.gif'
		];
		sbox.conf.chkIe = sbox.func.chkIe();
		sbox.conf.bgImg = (sbox.conf.padding == 0 ? false : sbox.conf.bgImg);
		if(sbox.conf.bgImg){
			if(sbox.conf.chkIe){
				sbox.reload.push(_dir + 'bg8.png');
			}else{
				sbox.reload.push(_dir + 'bg24.png');
			}
		}
		var _logo = new Image();
		_logo = document.createElement('img');
		_logo.onload = function(){
				sbox.conf.logoSize = sbox.func.imgSize(_logo);
				if(sbox.conf.logoSize.w != 'NA'){
					sbox.conf.showLogo = true;
				}
		}
		_logo.src = sbox.conf.graphicsDir + '/logo.png';
	},

	reload: function(){
		var _img, i;
		var _reload = sbox.reload;
		var _dir = sbox.conf.graphicsDir;
		for(i = 0; i < _reload.length; i++){
			_img = new Image();
			_img.src = _reload[i];
		}
	},

	setImgs: function(){
		var _thumb, _idx, _ev, _size;
		var _func = sbox.func;
		sbox.imgs = new Array();
		$("a[rel='lightbox']").each(function(_idx){
			$('img', this).css(sbox.conf.hoverOut);
			$(this).hover(
				function(){$('img', this).css(sbox.conf.hoverIn)},
				function(){$('img', this).css(sbox.conf.hoverOut)}
			);
			_thumb = ($('img', this).length == 0 ? $(this).attr('href') : $('img', this).attr('src'));
			sbox.imgs[_idx] = {
				img: $(this).attr('href'),
				thumb: _thumb
			};
			$(this).click(function(_ev){
				_func.modal(_idx);
				_ev.preventDefault();
			});
			var _img = new Image();
			_img = document.createElement('img');
			_img.onload = function(){
				_size = _func.imgSize(_img);
				_size = _func.resize(_size.w, _size.h, sbox.conf.thumbMaxW, sbox.conf.thumbMaxH);
				sbox.imgs[_idx].thumbW = _size.w;
				sbox.imgs[_idx].thumbH = _size.h;
			}
			_img.src = _thumb;
		});
	},

	modal: function(_idx){
		$('<img src="'+ sbox.conf.graphicsDir +'/ajax-loader-start.gif" id="modalLoader" />').modal({
			opacity: 80,
			containerId: 'modalCon',
			overlayId: 'modalOverlay',
			overlayCss: {
				backgroundColor: '#000'
			},
			containerCss: {
				width: '32px',
				height: '32px'
			},
			closeHTML: '',
			escClose: true,
			overlayClose: true,
			onClose: function(){ sbox.func.close(); },
			onOpen: function(_e){ sbox.func.open(_e, _idx); }
		});
	},

	open: function(_e, _idx){
		_e.overlay.fadeIn('fast', function(){
			_e.container.fadeIn('fast', function(){
				$('#modalLoader').fadeIn('fast', function(){
					sbox.func.loadImg(_idx, 'new');
				});
			});
		});
	},

	loadImg: function(_idx, _mode){
		var _img = new Image();
		_img = document.createElement('img');
		_img.onload = function(){
			if(_mode == 'new'){
				sbox.func.showImg(_idx, _img);
			}else{
				sbox.func.changeImg(_idx, _img);
			}
		}
		_img.src = sbox.imgs[_idx].img;
	},

	showImg: function(_idx, _img){
		var _param = this.param(_idx, _img);
		$('.simplemodal-wrap').remove();
		$('#modalCon').css({
			width: _param.wrapW + 'px',
			height: _param.conH + 'px',
			left: _param.conL + 'px',
			top: _param.conT + 'px',
			zIndex: 1003
		}).append(this.domWrap(_param));
		if(sbox.conf.showNav && _param.index){
			$('#modalCon').append($(this.domNav(_param)));
			this.navStyle();
		}
		$('#modalCon, #modalWrap').fadeIn('slow', function(){
			$('#modalLoader2').fadeIn('fast', function(){
				$('#modalLoader').hide();
				$('#modalImg').slideDown('slow').click(function(){ sbox.func.close(); });
				if($('#modalCon').children().is('#modalNav')){
					setTimeout(function(){
						$('#modalNav').fadeIn('fast');
						sbox.func.navEvent();
					}, 5);
				}
			});
		});
	},

	domNav: function(_param){
		var _temp = new Array();
		_temp.push('<div id="modalNav" style="width:' + _param.wrapW + 'px;height:' + sbox.conf.navH + 'px;display:none;">');
		if(_param.prevImg){
			_temp.push(this.navButton('prev', 'visible', _param.prevIdx));
			_temp.push('<img src="' + _param.prevImg.thumb + '" id="modalThumbPrev" width="'
			+ _param.prevImg.thumbW + '" height="' + _param.prevImg.thumbH + '" style="display:none;" />');
		}else{
			_temp.push(this.navButton('prev', 'hidden'));
		}
		_temp.push('<span id="modalIndex">' + _param.index + '</span>');
		if(_param.nextImg){
			_temp.push(this.navButton('next', 'visible', _param.nextIdx));
			_temp.push('<img src="' + _param.nextImg.thumb + '" id="modalThumbNext" width="'
			+ _param.nextImg.thumbW + '" height="' + _param.nextImg.thumbH + '" style="display:none;" />');
		}else{
			_temp.push(this.navButton('next', 'hidden'));
		}
		return _temp.join('') + '</div>';
	},

	navButton: function(_mode, _visibility, _rel){
		_rel = (_rel ? ' rel="' + _rel + '"' : '');
		var _pos = (_mode == 'prev' ? 'left top' : 'right top');
		return '<span style="width:60px;height:40px;background:url('+sbox.conf.graphicsDir+'/arrow.gif) '
		+ _pos +';visibility:' + _visibility + ';"' + _rel + ' id="modal' + _mode + '"></span>';
	},

	domWrap: function(_param){
		var _wrap, _img, _loader, _bg, _logo;
		_wrap = $('<div id="modalWrap"></div>');
		_img = $('<img src="' + _param.path + '" id="modalImg" />');
		_loader = $('<img src="' + sbox.conf.graphicsDir + '/ajax-loader.gif" id="modalLoader2" />');
		$(_wrap).css({
			width: _param.wrapW + 'px',
			height: _param.wrapH + 'px',
			zIndex: 1004,
			position: 'relative',
			top: 0,
			left: 0,
			display: 'none'
		});
		$(_loader).css({
			position: 'absolute',
			top: _param.loaderT + 'px',
			left: _param.loaderL + 'px',
			zIndex: 1005,
			display: 'none'
		});
		$(_img).attr({
			width: _param.w + 'px',
			height: _param.h + 'px'
		}).css({
			width: _param.w + 'px',
			height: _param.h + 'px',
			position: 'absolute',
			top: sbox.conf.padding + 'px',
			left: sbox.conf.padding + 'px',
			cursor: 'pointer',
			zIndex: 1006,
			display: 'none'
		});
		if(sbox.conf.bgImg){
			_bg = this.bgStyle(_param.wrapW, _param.wrapH);
			$('<div id="modalBg1"></div>').css(_bg[0]).appendTo($(_wrap));
			$('<div id="modalBg2"></div>').css(_bg[1]).appendTo($(_wrap));
			$('<div id="modalBg3"></div>').css(_bg[2]).appendTo($(_wrap));
			$('<div id="modalBg4"></div>').css(_bg[3]).appendTo($(_wrap));
		}else{
			$(_wrap).css( { background: sbox.conf.bgColor } );
		}
		$(_wrap).append(_loader).append(_img);
		if(sbox.conf.showLogo){
			_logo = $(this.png('logo', sbox.conf.logoSize.w, sbox.conf.logoSize.h, sbox.conf.chkIe, 'modalLogo', '', ''));
			$(_logo).css({
				position: 'absolute',
				zIndex: 1007
			}).css(sbox.conf.logoPosition).appendTo(_wrap);
		}
		return _wrap;
	},

	param: function(_idx, _img){
		var _imgSize, _windowSize, navParam, _wrapW, _wrapH, _index, _prev, _next, _prevIdx, _nextIdx;
		if(sbox.conf.navArrow && sbox.imgs.length > 1){
			sbox.conf.showNav = true;
			_index = _idx + 1;
			_index = _index + ' / ' + sbox.imgs.length;
			_prevIdx = _idx - 1;
			_nextIdx = _idx + 1;
			if(_idx > 0 && sbox.imgs[_prevIdx].thumbW && sbox.imgs[_prevIdx].thumbH){
				_prev = sbox.imgs[_prevIdx];
			}
			if(_idx < sbox.imgs.length-1 && sbox.imgs[_nextIdx].thumbW && sbox.imgs[_nextIdx].thumbH){
				_next = sbox.imgs[_nextIdx];
			}
		}else{
			sbox.conf.navH = sbox.conf.navMargin = 0;
			sbox.conf.showNav = false;
		}
		_windowSize = this.windowSize();
		_imgSize = this.imgSize(_img);
		_imgSize = this.resize(_imgSize.w, _imgSize.h, _windowSize.w - 180, _windowSize.h - 120 - sbox.conf.navH);
		_wrapW = _imgSize.w + sbox.conf.padding*2;
		_wrapH = _imgSize.h + sbox.conf.padding*2;
		return {
			path: sbox.imgs[_idx].img,
			w: _imgSize.w,
			h: _imgSize.h,
			wrapW: _wrapW,
			wrapH: _wrapH,
			conH: _wrapH + sbox.conf.navH + sbox.conf.navMargin,
			conL: (_windowSize.w - _wrapW) / 2,
			conT: (_windowSize.h - _wrapH - sbox.conf.navH - sbox.conf.navMargin) / 2,
			windowW: _windowSize.w,
			windowH: _windowSize.h,
			index: (_index ? _index : false),
			loaderL: (_wrapW - 32) / 2,
			loaderT: (_wrapH - 32 - sbox.conf.navH) / 2,
			prevImg: (_prev ? _prev : false),
			nextImg: (_next ? _next : false),
			prevIdx: (_prev ? _prevIdx : false),
			nextIdx: (_next ? _nextIdx : false)
		};
	},

	close: function(){
		if($.browser.opera){
			$('[id^="modal"]').hide().remove();
			$.modal.close();
		}else{
			$('#modalCon').fadeOut('fast', function(){
				$('#modalOverlay').fadeOut('fast', function(){
					$.modal.close();
				});
			});
		};
	},

	resize: function(_w, _h, _maxW, _maxH){
		var _x = (_maxH/_h >= _maxW/_w ? _maxW/_w : _maxH/_h);
		_x = (_x > 1 ? 1 : _x);
		return { w:parseInt(_x*_w), h:parseInt(_x*_h) };
	},

	imgSize: function(_img){
		var _w, _h;
		if($(_img).width() && $(_img).width() != 0){
			_w = _img.width();
			_h = _img.height();
		}else if(_img.naturalWidth && _img.naturalWidth != 0){
			_w = _img.naturalWidth;
			_h = _img.naturalHeight;
		}else{
			$('body').append(_img);
			$(_img).css({
				position: 'absolute',
				visibility: 'hidden',
				top: 0,
				left: 0
			});
			_w = _img.offsetWidth;
			_h = _img.offsetHeight;
			$(_img).remove();
		}
		return {
			w: (_w ? _w : 'NA'),
			h: (_h ? _h : 'NA')
		};
	},

	bgStyle: function(_wrapW, _wrapH){
		var _bgCss;
		var _padding = sbox.conf.padding;
		var _navH = sbox.conf.navH;
		if(sbox.conf.chkIe){
			_bgCss = sbox.conf.graphicsDir + '/bg8.png';
		}else{
			_bgCss = sbox.conf.graphicsDir + '/bg24.png';
		}
		return [
			{
				position:'absolute',
				zIndex: 4,
				top:0,
				left:0,
				width: _wrapW - _padding,
				height: _wrapH - _padding - _navH,
				background: 'url(' + _bgCss + ') left top no-repeat'
			},
			{
				position: 'absolute',
				zIndex: 3,
				top: 0,
				right: 0,
				width: _wrapW - _padding,
				height: _wrapH - _padding - _navH,
				background: 'url(' + _bgCss + ') right top no-repeat'
			},
			{
				position:'absolute',
				zIndex: 2,
				bottom: 0,
				left:0,
				width: _wrapW - _padding,
				height: _wrapH - _padding - _navH,
				background: 'url(' + _bgCss + ') left bottom no-repeat'
			},
			{
				position:'absolute',
				zIndex: 1,
				bottom: 0,
				right:0,
				width: _wrapW - _padding,
				height: _wrapH - _padding - _navH,
				background: 'url(' + _bgCss + ') right bottom no-repeat'
			}
		];
	},

	navStyle: function(){
		$('#modalNav').css({
			zIndex: 1007,
			left: 0,
			bottom: 0,
			position: 'absolute'
		});
		$('#modalIndex').css({
			color: '#ffffff',
			fontSize: '11px',
			fontFamily: 'arial',
			fontWeight: 'bold'
		});
		$('#modalnext, #modalprev').css({
			border: 'none',
			verticalAlign: 'middle',
			display: 'inline-block',
			cursor: 'pointer'
		});
		$('#modalCon').css({
			textAlign: 'center'
		});
		$('#modalThumbPrev, #modalThumbNext').css({
			position: 'absolute',
			bottom: '50px',
			zIndex: '1005',
			display: 'none'
		});
		$('#modalThumbPrev').css({
			left: '-30px'
		});
		$('#modalThumbNext').css({
			right: '-30px'
		});
	},

	windowSize: function(){
		var _windowSize = $.modal.impl.getDimensions();
		return {
			h: _windowSize[0],
			w: _windowSize[1]
		}
	},

	png: function(_png, _w, _h, _chkIe, _id, _css, _attr){
		var iePngStyle = function(_png){
			return 'filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src=' + _png + '.png)';
		};
		if(_chkIe){
			return '<span id="'+ _id +'" style="width:' + _w + 'px;height:' + _h + 'px;'
			+ iePngStyle(sbox.conf.graphicsDir + '/' + _png) + ';' + _css + '"' + _attr + '></span>';
		}else{
			return '<img src="' + sbox.conf.graphicsDir + '/' + _png + '.png" width="'
			+ _w + '" height="' + _h + '" id="' + _id + '" style="' + _css + '"' + _attr + ' />';
		}
	},

	navEvent: function(){
		$('#modalprev').hover(
			function(){
				$('#modalThumbPrev').fadeIn('slow').fadeTo('fast', 0.8);
				$(this).css({backgroundPosition:'left bottom'});
			},
			function(){
				$('#modalThumbPrev').fadeOut('slow');
				$(this).css({backgroundPosition:'left top'});
			}
		);
		$('#modalnext').hover(
			function(){
				$('#modalThumbNext').fadeIn('slow').fadeTo('fast', '0.8');
				$(this).css({backgroundPosition:'right bottom'});
			},
			function(){
				$('#modalThumbNext').fadeOut('slow');
				$(this).css({backgroundPosition:'right top'});
			}
		);
		$('#modalprev, #modalnext').unbind('click').click(function (){ 
			var _idx = $(this).attr('rel') - 0;
			if(!_idx) { _idx = 0 };
			if(sbox.conf.showLogo){
				$('#modalLogo').fadeOut('fast');
			}
			$('#modalImg').fadeOut('fast', function(){
				$('#modalNav').fadeOut('fast', function(){
					$('#modalNav').remove();
					sbox.func.loadImg(_idx, 'change');
				});
			});
		});
	},

	changeImg: function(_idx, _img){
		var _conCss, _bg;
		var _param = this.param(_idx, _img);
		if(sbox.conf.chkIe){
			_conCss = {
				width: _param.wrapW,
				height: _param.conH
			};
		}else{
			_conCss = {
				width: _param.wrapW,
				height: _param.conH,
				top: _param.conT,
				left: _param.conL
			};
		}
		if(sbox.conf.bgImg){
			_bg = this.bgStyle(_param.wrapW, _param.wrapH);
			$('#modalBg1').animate({
				'width': _bg[0].width,
				'height': _bg[0].height
			}, 'slow');
			$('#modalBg2').animate({
				'width': _bg[1].width,
				'height': _bg[1].height
			}, 'slow');
			$('#modalBg3').animate({
				'width': _bg[2].width,
				'height': _bg[2].height
			}, 'slow');
			$('#modalBg4').animate({
				'width': _bg[3].width,
				'height': _bg[3].height
			}, 'slow');
		}
		$('#modalWrap').animate({
			'width':_param.wrapW,
			'height':_param.wrapH
		}, 'slow');
		$('#modalLoader2').animate({
			'top':_param.loaderT,
			'left':_param.loaderL
		}, 'slow');
		$('#modalCon').animate(_conCss, 'slow', function(){
			$('#modalImg').attr({
				'width': _param.w,
				'height': _param.h,
				'src': _param.path
			}).css({
				'width': _param.w + 'px',
				'height': _param.h + 'px'
			}).fadeIn('fast', function(){
				$('#modalWrap, #modalCon').css('overflow','visible');
				if(sbox.conf.showLogo){ $('#modalLogo').fadeIn('fast'); }
				if(sbox.conf.showNav && _param.index){
					$('#modalCon').append($(sbox.func.domNav(_param)));
					sbox.func.navStyle();
					sbox.func.navEvent();
					setTimeout(function(){
						$('#modalNav').fadeIn('fast');
					}, 5);
				}
			});
		});
	},

	chkIe: function(){
		if($.browser.msie && $.browser.version.match(/^6/)){
			return true;
		}else{
			return false;
		}
	}

};
